package de.bebagoe.util.conio;

import java.util.*;
import java.io.*;

public class Simput {
    static private boolean error;
    static private String  errorDescription = "";

    static public int gint(String prompt) {
        int eingabe = 0;
        @SuppressWarnings("resource")
        Scanner input = new Scanner(System.in);
        if (prompt != null)
            IO.print(prompt);
        try {
            eingabe = input.nextInt();
            error = false;
            errorDescription = "";
        } catch(Exception e) {
            error = true;
            errorDescription = "Die Eingabe konnte nicht konvertiert werden.";
            IO.println("Falsche Eingabe!\n");
        }
        return eingabe;
    }

    static public int gint() {
        return gint(null);
    }

    static public long glong(String prompt) {
        long eingabe = 0;
        @SuppressWarnings("resource")
        Scanner input = new Scanner(System.in);
        if (prompt != null)
            IO.print(prompt);
        try {
            eingabe = input.nextLong();
            error = false;
            errorDescription = "";
        } catch(Exception e) {
            error = true;
            errorDescription = "Die Eingabe konnte nicht konvertiert werden.";
            IO.println("Falsche Eingabe!\n");
        }
        return eingabe;
    }

    static public long glong() {
        return glong(null);
    }

    static public double gdouble(String prompt) {
        double eingabe = 0.0;
        @SuppressWarnings("resource")
        Scanner input = new Scanner(System.in);
        if (prompt != null)
            IO.print(prompt);
        try {
            eingabe = input.nextDouble();
            error = false;
            errorDescription = "";
        } catch(Exception e) {
            error = true;
            errorDescription = "Die Eingabe konnte nicht konvertiert werden.";
            IO.println("Falsche Eingabe!\n");
        }
        return eingabe;
    }

    static public double gdouble() {
        return gdouble(null);
    }

    static public char gchar(String prompt) {
        char eingabe = '?';
        @SuppressWarnings("resource")
        Scanner input = new Scanner(System.in);
        if (prompt != null)
            IO.print(prompt);
        try {
            eingabe = input.next().charAt(0);
            error = false;
            errorDescription = "";
        } catch(Exception e) {
            error = true;
            errorDescription = "Fehler beim Lesen aus System.in";
            IO.println("Fehler beim Lesen aus System.in\n");
        }
        return eingabe;
    }

    static public char gchar() {
        return gchar(null);
    }

    static public void went(String prompt) {  // Wait for Enter
        if (prompt != null)
            IO.print(prompt);
        BufferedReader in = new BufferedReader(
                new InputStreamReader(System.in));
        try {
            in.readLine();
            error = false;
            errorDescription = "";
        } catch(Exception e) {
            error = true;
            errorDescription = "Unbekannter Fehler";
            IO.println("Unbekannter Fehler\n");
        }
    }

    static void went() {
        went(null);
    }

    static public boolean checkError() {
        return error;
    }

    static public String getErrorDescription() {
        return errorDescription;
    }
}